<?php
if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

/**
* Class that provides payment verification and form generation functions
*
* @package	vBulletin
* @version	$Revision: 20000 $
* @date		$Date: 2016-10-21 01:24:45 +0350 (Fri, 21 October 2016) $
*/
class vB_PaidSubscriptionMethod_gateway extends vB_PaidSubscriptionMethod
{
	var $supports_recurring = false;	 
	var $display_feedback = true;

	function verify_payment()
	{
        global $vbulletin;
        
		$this->registry->input->clean_array_gpc('r', array(
			'item'		=> TYPE_STR
		));  
		
		if (!extension_loaded('curl') || !function_exists('file_get_contents'))
		{
			$this->error = 'Curl Extension And file_get_contents Function Required';
			return false;
		}
		
		if (!$this->test())
		{
			$this->error = 'Payment processor not configured';
			return false;
		}
        $this->transaction_id = $this->registry->GPC['item'];
		if(!empty($this->registry->GPC['item'])) {
			$this->paymentinfo = $this->registry->db->query_first("
				SELECT paymentinfo.*, user.username
				FROM " . TABLE_PREFIX . "paymentinfo AS paymentinfo
				INNER JOIN " . TABLE_PREFIX . "user AS user USING (userid)
				WHERE hash = '" . $this->registry->db->escape_string($this->registry->GPC['item']) . "'
			");
			if (!empty($this->paymentinfo)) {
				$sub = $this->registry->db->query_first("SELECT * FROM " . TABLE_PREFIX . "subscription WHERE subscriptionid = " . $this->paymentinfo['subscriptionid']);
				$cost = unserialize($sub['cost']);				
				$amount = floor($cost[0][cost][usd]*$vbulletin->options['gateway_d2t']*10);
				
                $ch = curl_init();
                curl_setopt($ch,CURLOPT_URL,$vbulletin->options['gateway_url'].'invoice/check/'.$_COOKIE['gateway_invoice_key']);
                curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=".$vbulletin->options['gateway_api_key']);
                curl_setopt($ch,CURLOPT_POST,true);
                curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
                curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
                curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
                curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
                $res = curl_exec($ch);
                curl_close($ch);
                
                $result = json_decode($res, 1);
                if($result['status'] == 1) {
                    if($amount == $result['amount']) {
                        $this->paymentinfo['currency'] = 'usd';
                        $this->paymentinfo['amount'] = $cost[0][cost][usd];                
                        $this->type = 1;
                        return true;
                    } else {
                        $this->error = 'ERR: '. 'Amount paid doesn\'t match with invoice amount';
                        return false;
                    }
                } else {
                    $this->error = 'ERR: '. $result['errorCode'].' - '.$result['errorDescription'];
                    return false;
                }
			} else {
				$this->error = 'Invalid trasaction';
				return false;	
			}
		} else {		
			$this->error = 'Duplicate transaction.';
			return false;
		}
    }

	function test()
	{	
        global $vbulletin;
		if (extension_loaded('curl') && function_exists('file_get_contents')) {
			if(!empty($vbulletin->options['gateway_api_key']) && !empty($vbulletin->options['gateway_d2t']) && !empty($vbulletin->options['gateway_url'])){
				return true;
			}
		}
		return false;
	}

	function generate_form_html($hash, $cost, $currency, $subinfo, $userinfo, $timeinfo)
	{
		global $vbphrase, $vbulletin, $show;
        
		$item = $hash;
		$cost = floor($cost*$vbulletin->options['gateway_d2t']*10);
        $gateway_url = $vbulletin->options['gateway_url'];
		$gateway_api_key = $vbulletin->options['gateway_api_key'];
		
		$form['action'] = 'gateway.php';
		$form['method'] = 'POST';        
			
		$settings =& $this->settings;
		
		$templater = vB_Template::create('subscription_payment_gateway');
        $templater->register('gateway_api_key', $gateway_api_key);
	    $templater->register('gateway_url', $gateway_url);
		$templater->register('cost', $cost);
		$templater->register('item', $item);					
		$templater->register('subinfo', $subinfo);
		$templater->register('settings', $settings);
		$templater->register('userinfo', $userinfo);
		$form['hiddenfields'] .= $templater->render();
		return $form;
	}
}
?>