<?php
ini_set('display_errors', 1);
defined('_JEXEC') or die('Restricted access');
require_once JPATH_ADMINISTRATOR . '/components/com_rsmembership/helpers/rsmembership.php';

class plgSystemRSMembershipZardis extends JPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
        // load languages
        $this->loadLanguage('plg_system_rsmembership', JPATH_ADMINISTRATOR);
        $this->loadLanguage('plg_system_rsmembershipZardis', JPATH_ADMINISTRATOR);

        RSMembership::addPlugin($this->translate('nice_name'), 'rsmembershipZardis');
    }

    /**
     * call when payment starts
     *
     * @param $plugin
     * @param $data
     * @param $extra
     * @param $membership
     * @param $transaction
     * @param $html
     */
     
    

    function pay($api_key, $amount, $redirect) {
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/request');
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key&amount=$amount&return_url=$redirect");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }

    function verify($api_key, $inv_key) {
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/check/'.$inv_key);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
    public function onMembershipPayment($plugin, $data, $extra, $membership, $transaction, $html)
    {
        $app = JFactory::getApplication();
        try {
            if ($plugin != 'rsmembershipZardis')
                return;

            $api_key = trim($this->params->get('api_key'));
            $extra_total = 0;
            foreach ($extra as $row) {
                $extra_total += $row->price;
            }

            $Amount = $this->ZardisAmount($transaction->price + $extra_total);

            $Description = $membership->name;
            $Description = $this->escape($Description);

            $Email = $data->email;
            $Mobile = '';

            $transaction->custom = md5($transaction->params . ' ' . time());
            if ($membership->activation == 2) {
                $transaction->status = 'completed';
            }
            $transaction->store();

            $CallbackURL = JURI::base() . 'index.php?option=com_rsmembership&ZardisPayment=1&amount=' . $Amount;
            $CallbackURL = JRoute::_($CallbackURL, false);
            $session =& JFactory::getSession();
            $session->set('transaction_custom', $transaction->custom);
            $session->set('membership_id', $membership->id);

            $result = $this->pay($api_key, $Amount,$CallbackURL);
            $result = json_decode($result);
            if($result->status) {
                $go = "https://pay.zardis.net/invoice/pay/".$result->invoice_key;
                $app->redirect($go);
            }
            
            throw new Exception('status_'.$result->error_code);

        } catch (Exception $e) {
            $message = $this->translate('error_title') . '<br>' . $this->translate($e->getMessage());
            $app->redirect(JRoute::_(JURI::base() . 'index.php/component/rsmembership/view-membership-details/' . $membership->id, false), $message, 'warning');
            exit;
        }
    }


    /**
     * after payment completed
     * calls function onPaymentNotification()
     */
    public function onAfterDispatch()
    {
        $app = JFactory::getApplication();
        if ($app->input->getBoolean('ZardisPayment')) {
            $this->onPaymentNotification($app);
        }
    }

    /**
     * process payment verification and approve subscription
     * @param $app
     */
    protected function onPaymentNotification($app)
    {
        $input = $app->input;
        $session =& JFactory::getSession();

        $transaction_custom = $session->get('transaction_custom');

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*')
            ->from($db->quoteName('#__rsmembership_transactions'))
            ->where($db->quoteName('status') . ' != ' . $db->quote('completed'))
            ->where($db->quoteName('custom') . ' = ' . $db->quote($transaction_custom));
        $db->setQuery($query);
        $transaction = @$db->loadObject();

        try {
            if (!$transaction)
                throw new Exception('transaction_not_found', 1);

            if ($input->getString('Status') != 'OK')
                throw new Exception('payment_failed');

            $api_key = $this->params->get('api_key');
            $inv_key = $input->getString('invoice_key');
            
            $result = $this->verify($api_key, $inv_key);
            $result = json_decode($result);

            if (!$result->status)
                throw new Exception('connection_error');

            $status = $result->status;

            if ($status) {
                $bank_code = $result->bank_code;

                $query->clear();
                $query->update($db->quoteName('#__rsmembership_transactions'))
                    ->set($db->quoteName('hash') . ' = ' . $db->quote($bank_code))
                    ->where($db->quoteName('id') . ' = ' . $db->quote($transaction->id));

                $db->setQuery($query);
                $db->execute();

                $membership_id = $session->get('membership_id');

                if (!$membership_id)
                    throw new Exception('membership_not_found');

                $query->clear()
                    ->select('activation')
                    ->from($db->quoteName('#__rsmembership_memberships'))
                    ->where($db->quoteName('id') . ' = ' . $db->quote((int)$membership_id));
                $db->setQuery($query);
                $activation = $db->loadResult();

                if ($activation) // activation == 0 => activation is manual
                {
                    RSMembership::approve($transaction->id);
                }

                $message = sprintf($this->translate('payment_succeed'), $bank_code);

                $app->redirect(JRoute::_(JURI::base() . 'index.php?option=com_rsmembership&view=mymemberships', false), $message, 'message');
                die();
            }

            throw new Exception('status_' . $result->error_code);

        } catch (Exception $e) {
            if (!$e->getCode()) // means transaction found but should be denied
            {
                RSMembership::deny($transaction->id);
            }

            $message = $this->translate('error_title') . '<br>' . $this->translate($e->getMessage());
            $app->enqueueMessage($message, 'warning');
        }
    }

    /**
     * escape string
     * @param $string
     *
     * @return string
     */
    protected function escape($string)
    {
        return htmlentities($string, ENT_COMPAT, 'utf-8');
    }

    /**
     * translate plugin language files
     * @param $key
     * @return mixed
     */
    protected function translate($key)
    {
        $key = 'PLG_RSM_Zardis_' . strtoupper($key);
        return JText::_($key);
    }

    /**
     * fix Zardis amount
     *
     * @param $amount
     *
     * @return int
     */
    private function ZardisAmount($amount)
    {
        $currency = $this->params->get('currency');
        if ($currency == 0) { // currency == 1 => rial , 0 => Toman
            $amount = $amount * 10;
        }

        return $amount;
    }

}