<?php

if (!defined('ABSPATH')) {
  die('This file cannot be accessed directly');
}


if (!class_exists('RCP_Zardis')) {

	class RCP_Zardis
	{

      
		public function __construct()
		{
			add_action('init', array($this, 'Zardis_Verify'));
			add_action('rcp_payments_settings', array($this, 'Zardis_Setting'));
			add_action('rcp_gateway_Zardis', array($this, 'Zardis_Request'));
			add_filter('rcp_payment_gateways', array($this, 'Zardis_Register'));
		    add_filter('rcp_currencies', array($this, 'Zardis_Currencies'));
			add_filter( 'rcp_is_zero_decimal_currency', '__return_true' );
           
		}
        


		public function Zardis_Currencies($currencies)
		{
			unset($currencies['RIAL']);

			$currencies['تومان'] = __('تومان', 'rcp_zardis');
			$currencies['ریال'] = __('ریال', 'rcp_zardis');

			return $currencies;

		}
				
		public function Zardis_Register($gateways)
		{
			global $rcp_options;

			$zardis = 'درگاه پرداخت و کیف پول الکترونیک زردیس پی';

			if (version_compare(RCP_PLUGIN_VERSION, '2.1.0', '<')) {

				$gateways['Zardis'] = isset($rcp_options['zardis_name']) ? $rcp_options['zardis_name'] : __($zardis, 'rcp_zardis');

			} else {

				$gateways['Zardis'] = array(

					'label'       => isset($rcp_options['zardis_name']) ? $rcp_options['zardis_name'] : __($zardis, 'rcp_zardis'),
					'admin_label' => isset($rcp_options['zardis_name']) ? $rcp_options['zardis_name'] : __($zardis, 'rcp_zardis'),
                    'class' => 'RCP_Zardis',
				);
			}

			return $gateways;


		}

		public function Zardis_Setting($rcp_options)
		{
		?>	
			<hr/>
			<table class="form-table">
				<?php do_action('RCP_Zardis_before_settings', $rcp_options); ?>
				<tr valign="top">
					<th colspan="2">
						<h3><?php _e('تنظیمات درگاه پرداخت و کیف پول الکترونیک زردیس پی', 'rcp_zardis'); ?></h3>
					</th>
				</tr>
				<tr valign="top">
					<th>
						<label for="rcp_settings[zardis_api]"><?php _e('کلید API', 'rcp_zardis'); ?></label>
					</th>
					<td>
						<input class="regular-text" id="rcp_settings[zardis_api]" style="width:300px;" name="rcp_settings[zardis_api]" value="<?php if (isset($rcp_options['zardis_api'])) { echo $rcp_options['zardis_api']; } ?>"/>
					</td>
				</tr>				
				<tr valign="top">
					<th>
						<label for="rcp_settings[zardis_query_name]"><?php _e('نام لاتین درگاه پرداخت', 'rcp_zardis'); ?></label>
					</th>
					<td>
						<input class="regular-text" id="rcp_settings[zardis_query_name]" style="width:300px;" name="rcp_settings[zardis_query_name]" value="<?php echo isset($rcp_options['zardis_query_name']) ? $rcp_options['zardis_query_name'] : 'Zardis'; ?>"/>
						<div class="description"><?php _e('این نام در هنگام بازگشت از بانک در آدرس بازگشت از بانک نمایان خواهد شد<br/>این نام باید با نام سایر درگاه ها متفاوت باشد', 'rcp_zardis'); ?></div>
					</td>
				</tr>
				<tr valign="top">
					<th>
						<label for="rcp_settings[zardis_name]"><?php _e('نام نمایشی درگاه پرداخت', 'rcp_zardis'); ?></label>
					</th>
					<td>
						<input class="regular-text" id="rcp_settings[zardis_name]" style="width:300px;" name="rcp_settings[zardis_name]" value="<?php echo isset($rcp_options['zardis_name']) ? $rcp_options['zardis_name'] : __('درگاه پرداخت و کیف پول الکترونیک زردیس پی', 'rcp_zardis'); ?>"/>
					</td>
				</tr>
				<tr valign="top">
					<th>
						<label><?php _e('تذکر ', 'rcp_zardis'); ?></label>
					</th>
					<td>
						<div class="description"><?php _e('از سربرگ مربوط به ثبت نام در تنظیمات افزونه حتما یک برگه برای بازگشت از بانک انتخاب نمایید<br/>ترجیحا نامک برگه را لاتین قرار دهید<br/> نیازی به قرار دادن شورت کد خاصی در برگه نیست و میتواند برگه ی خالی باشد', 'rcp_zardis'); ?></div>
					</td>
				</tr>
				<?php do_action('RCP_Zardis_after_settings', $rcp_options); ?>
			</table>
			<?php
		}
		
		public function Zardis_Request($subscription_data)
		{
			$new_subscription_id = get_user_meta($subscription_data['user_id'], 'rcp_subscription_level', TRUE);

			if (!empty($new_subscription_id)) {

				update_user_meta($subscription_data['user_id'], 'rcp_subscription_level_new', $new_subscription_id);
			}
			
			$old_subscription_id = get_user_meta($subscription_data['user_id'], 'rcp_subscription_level_old', TRUE);

			update_user_meta($subscription_data['user_id'], 'rcp_subscription_level', $old_subscription_id);
			
			global $rcp_options;

			ob_start();

			$query  = isset($rcp_options['zardis_query_name']) ? $rcp_options['zardis_query_name'] : 'Zardis';
			$amount = str_replace(array(',','.'), '', $subscription_data['price']);

			$zardis_payment_data = array(

				'user_id'           => $subscription_data['user_id'],
				'subscription_name' => $subscription_data['subscription_name'],
				'subscription_key'  => $subscription_data['key'],
				'amount'            => $amount
			);		
			
			$ZARDISStd_session = ZARDIS_Session::get_instance();
			@session_start();
			$ZARDISStd_session['zardis_payment_data'] = $zardis_payment_data;
			$_SESSION['zardis_payment_data'] = $zardis_payment_data;

			do_action('RCP_Before_Sending_to_Zardis', $subscription_data);

			if (extension_loaded('curl')) {

				$currency = $rcp_options['currency'];
				

				if ($currency == 'تومان' || $currency == 'TOMAN' || $currency == 'تومان ایران' || $currency == 'IRT' || $currency == 'Iranian Toman') {

					$amount = $amount * 10;
				}

				$api_key  = isset($rcp_options['zardis_api']) ? $rcp_options['zardis_api'] : NULL;
				$callback = add_query_arg('gateway', $query, $subscription_data['return_url']);

				$params = array(

					'api_key'          => $api_key,
					'amount'       => intval($amount),
					'return_url'     => urlencode($callback),
					'factorNumber' => $subscription_data['post_data']['rcp_register_nonce']
				);

				

				$result = $this->common('https://pay.zardis.net/invoice/request', $params);

				if ($result && isset($result->status) && $result->status == 1) {

					$gateway_url = 'https://pay.zardis.net/invoice/pay/' . $result->invoice_key;

					wp_redirect($gateway_url);

				} else {

					$fault = 'در ارتباط با وب سرویس زردیس پی خطایی رخ داده است';

					$fault = isset($result->errorDescription) ? $result->errorDescription : $fault;

					wp_die(sprintf(__('متاسفانه پرداخت به دلیل خطای زیر امکان پذیر نمی باشد<br/><b>%s</b>', 'rcp_zardis'), $fault));
				}

			} else {

				$fault = 'تابع cURL در سرور فعال نمی باشد';

				wp_die(sprintf(__('متاسفانه پرداخت به دلیل خطای زیر امکان پذیر نمی باشد<br/><b>%s</b>', 'rcp_zardis'), $fault));
			}

			exit;
		}
		
		public function Zardis_Verify()
		{
			if (!isset($_GET['gateway'])) {

				return;
			}

			if (!class_exists('RCP_Payments')) {

				return;
			}

			global $rcp_options, $wpdb, $rcp_payments_db_name;
			

			@session_start();
			$ZARDISStd_session = ZARDIS_Session::get_instance();
			
			if (isset($ZARDISStd_session['zardis_payment_data'])) {
                $zardis_payment_data = $ZARDISStd_session['zardis_payment_data'];
            } else {
                $zardis_payment_data = isset($_SESSION['zardis_payment_data']) ? $_SESSION['zardis_payment_data'] : NULL;
            }

			$query = isset($rcp_options['zardis_query_name']) ? $rcp_options['zardis_query_name'] : 'Zardis';

			if (($_GET['gateway'] == $query) && $zardis_payment_data) {

				$user_id           = $zardis_payment_data['user_id'];
				$subscription_name = $zardis_payment_data['subscription_name'];
				$subscription_key  = $zardis_payment_data['subscription_key'];
				$amount            = $zardis_payment_data['amount'];
				

				$payment_method = isset($rcp_options['zardis_name']) ? $rcp_options['zardis_name'] : __('درگاه پرداخت و کیف پول الکترونیک زردیس پی', 'rcp_zardis');

				$new_payment = TRUE;

				$get_result = $wpdb->get_results($wpdb->prepare("SELECT id FROM " . $rcp_payments_db_name . " WHERE `subscription_key`='%s' AND `payment_type`='%s';", $subscription_key, $payment_method));

				if ($get_result) {

					$new_payment = FALSE;
				}

				unset($GLOBALS['zardis_new']);

				$GLOBALS['zardis_new'] = $new_payment;

				global $new;

				$new = $new_payment;

				if ($new_payment == 1) {

					if (isset($_POST['invoice_key']) && isset($_POST['invoice_key'])) {


                        $invoice_key=$_POST['invoice_key'];
							$api_key = isset($rcp_options['zardis_api']) ? $rcp_options['zardis_api'] : NULL;

							$params = array (
								'api_key'     => $api_key
							);

							$result = $this->common('https://pay.zardis.net/invoice/check/'.$invoice_key, $params);

						if ($result && isset($result->status) && $result->status == 1) {
							if ($result && isset($result->status) && $result->status == 1) {

								$card_number = isset($result->cardNumber) ? sanitize_text_field($result->cardNumber) : 'Null';
                                $factor_number = isset($result->factorNumber) ? sanitize_text_field($result->factorNumber) : 'Null';

                                $currency = $rcp_options['currency'];
								
								if ($currency == 'تومان' || $currency == 'TOMAN' || $currency == 'تومان ایران' || $currency == 'IRT' || $currency == 'Iranian Toman') {

									$amount = $amount * 10;
								}

								if (intval($amount) == $result->amount) {

									$fault = NULL;

									$payment_status = 'completed';
//									$transaction_id = $result->transId;
									$transaction_id = $result->bank_code;

								} else {

									$fault = 'رقم تراكنش با رقم پرداخت شده مطابقت ندارد';

									$payment_status = 'failed';
//									$transaction_id = $result->transId;
									$transaction_id = $result->bank_code;
								}

							} else {

								$fault = 'در ارتباط با وب سرویس زردیس پی و بررسی تراکنش خطایی رخ داده است';
								$fault = isset($result->errorDescription) ? $result->errorDescription : $fault;

								$payment_status = 'failed';
//								$transaction_id = $result->transId;
								$transaction_id = $result->bank_code;
							}

						} else {

							if ($message) {

								$fault = $message;

								$payment_status = 'failed';
								$transaction_id = $GLOBALS['zardis_transaction_id'];

							} else {

								$fault = 'تراكنش با خطا مواجه شد و یا توسط پرداخت کننده کنسل شده است';

								$payment_status = 'cancelled';
								$transaction_id = $GLOBALS['zardis_transaction_id'];
							}
						}

					} else {

						$fault = 'اطلاعات ارسال شده مربوط به تایید تراکنش ناقص و یا غیر معتبر است';

						$payment_status = 'failed';
						$transaction_id = NULL;
					}

					unset($GLOBALS['zardis_payment_status']);
					unset($GLOBALS['zardis_transaction_id']);
					unset($GLOBALS['zardis_fault']);
					unset($GLOBALS['zardis_subscription_key']);

					$GLOBALS['zardis_payment_status']   = $payment_status;
					$GLOBALS['zardis_transaction_id']   = $transaction_id;
					$GLOBALS['zardis_subscription_key'] = $subscription_key;
					$GLOBALS['zardis_fault']            = $fault;

					global $zardis_transaction;

					$zardis_transaction = array();

					$zardis_transaction['zardis_payment_status']   = $payment_status;
					$zardis_transaction['zardis_transaction_id']   = $transaction_id;
					$zardis_transaction['zardis_subscription_key'] = $subscription_key;
					$zardis_transaction['zardis_fault']            = $fault;

					if ($payment_status == 'completed') {

						$payment_data = array(

							'date'             => date('Y-m-d g:i:s'),
							'subscription'     => $subscription_name,
							'payment_type'     => $payment_method,
							'subscription_key' => $subscription_key,
							'amount'           => $zardis_payment_data['amount'],
							'user_id'          => $user_id,
							'transaction_id'   => $transaction_id
						);

						do_action('RCP_Zardis_Insert_Payment', $payment_data, $user_id);

						$rcp_payments = new RCP_Payments();

						$rcp_payments->insert($payment_data);

						$new_subscription_id = get_user_meta($user_id, 'rcp_subscription_level_new', TRUE);

						if (!empty($new_subscription_id)) {

							update_user_meta($user_id, 'rcp_subscription_level', $new_subscription_id);
						}

						rcp_set_status($user_id, 'active');

						if (version_compare(RCP_PLUGIN_VERSION, '2.1.0', '<')) {

							rcp_email_subscription_status($user_id, 'active');

							if (! isset($rcp_options['disable_new_user_notices'])) {

								wp_new_user_notification($user_id);
							}
						}

						update_user_meta($user_id, 'rcp_payment_profile_id', $user_id);
						update_user_meta($user_id, 'rcp_signup_method', 'live');
						update_user_meta($user_id, 'rcp_recurring', 'no'); 
					
						$subscription = rcp_get_subscription_details(rcp_get_subscription_id($user_id));
						$member_new_expiration = date('Y-m-d H:i:s', strtotime('+' . $subscription->duration . ' ' . $subscription->duration_unit . ' 23:59:59'));

						rcp_set_expiration_date($user_id, $member_new_expiration);
						delete_user_meta($user_id, '_rcp_expired_email_sent');

						$post_title   = __('تایید پرداخت', 'rcp_zardis');
						$post_content = __('پرداخت با موفقیت انجام شد شماره تراکنش: ' . $transaction_id, 'rcp_zardis') . __(' روش پرداخت: ', 'rcp_zardis');

						$log_data = array(

							'post_title'   => $post_title,
							'post_content' => $post_content . $payment_method,
							'post_parent'  => 0,
							'log_type'     => 'gateway_error'
						);

						$log_meta = array(

							'user_subscription' => $subscription_name,
							'user_id'           => $user_id
						);

						$log_entry = WP_Logging::insert_log($log_data, $log_meta);

						do_action('RCP_Zardis_Completed', $user_id);
					}

					if ($payment_status == 'cancelled') {

						$post_title   = __('انصراف از پرداخت', 'rcp_zardis');
						$post_content = __('تراکنش به دلیل خطای رو به رو ناموفق باقی ماند: ', 'rcp_zardis') . $fault . __(' روش پرداخت: ', 'rcp_zardis');

						$log_data = array(

							'post_title'   => $post_title,
							'post_content' => $post_content . $payment_method,
							'post_parent'  => 0,
							'log_type'     => 'gateway_error'
						);

						$log_meta = array(

							'user_subscription' => $subscription_name,
							'user_id'           => $user_id
						);

						$log_entry = WP_Logging::insert_log($log_data, $log_meta);

						do_action('RCP_Zardis_Cancelled', $user_id);
					}

					if ($payment_status == 'failed') {

						$post_title   = __('خطا در پرداخت', 'rcp_zardis');
						$post_content = __('تراکنش به دلیل خطای رو به رو ناموفق باقی ماند: ', 'rcp_zardis') . $fault . __(' روش پرداخت: ', 'rcp_zardis');

						$log_data = array(

							'post_title'   => $post_title,
							'post_content' => $post_content . $payment_method,
							'post_parent'  => 0,
							'log_type'     => 'gateway_error'
						);

						$log_meta = array(

							'user_subscription' => $subscription_name,
							'user_id'           => $user_id
						);

						$log_entry = WP_Logging::insert_log($log_data, $log_meta);

						do_action('RCP_Zardis_Failed', $user_id);
					}
				}

				add_filter('the_content', array($this, 'Zardis_Content_After_Return'));
			}
		}

		public function Zardis_Content_After_Return($content)
		{ 
			global $zardis_transaction, $new;
			$ZARDISStd_session = ZARDIS_Session::get_instance();
			@session_start();

			$new_payment = isset($GLOBALS['zardis_new']) ? $GLOBALS['zardis_new'] : $new;
			
			$payment_status = isset($GLOBALS['zardis_payment_status']) ? $GLOBALS['zardis_payment_status'] : $zardis_transaction['zardis_payment_status'];
			$transaction_id = isset($GLOBALS['zardis_transaction_id']) ? $GLOBALS['zardis_transaction_id'] : $zardis_transaction['zardis_transaction_id'];

			$fault = isset($GLOBALS['zardis_fault']) ? $GLOBALS['zardis_fault'] : $zardis_transaction['zardis_fault'];
			
			if ($new_payment == 1)  {
			
				$zardis_data = array(

					'payment_status' => $payment_status,
					'transaction_id' => $transaction_id,
					'fault'          => $fault
				);
				$ZARDISStd_session['zardis_data'] = $zardis_data;
				$_SESSION['zardis_data'] = $zardis_data;
			
			} else {

				if (isset($ZARDISStd_session['zardis_data'])) {
                    $zardis_payment_data = $ZARDISStd_session['zardis_data'];
                } else {
                    $zardis_payment_data = isset($_SESSION['zardis_data']) ? $_SESSION['zardis_data'] : NULL;
                }

				
			
				$payment_status = isset($zardis_payment_data['payment_status']) ? $zardis_payment_data['payment_status'] : NULL;
				$transaction_id = isset($zardis_payment_data['transaction_id']) ? $zardis_payment_data['transaction_id'] : NULL;

				$fault = isset($zardis_payment_data['fault']) ? $zardis_payment_data['fault'] : NULL;
			}

			$message = NULL;

			if ($payment_status == 'completed') {

				$message = '<br/>' . __('تراکنش با موفقیت انجام شد. شماره پیگیری تراکنش ', 'rcp_zardis') . $transaction_id . '<br/>';
			}

			if ($payment_status == 'cancelled') {

				$message = '<br/>' . __('تراکنش به دلیل انصراف شما نا تمام باقی ماند', 'rcp_zardis');
			}

			if ($payment_status == 'failed') {

				$message = '<br/>' . __('تراکنش به دلیل خطای زیر ناموفق باقی باند', 'rcp_zardis') . '<br/>' . $fault . '<br/>';
			}

			return $content . $message;
		}

		private static function common($url, $params)
		{
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, TRUE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));

			$response = curl_exec($ch);
			$error    = curl_errno($ch);

			curl_close($ch);

			$output = $error ? FALSE : json_decode($response);

			return $output;
		}

		public function process_webhooks(){}

		public function scripts(){}

		public function fields(){}


		public function validate_fields(){}


		public function supports($item = '')
		{
			return;
		}
	}	
}

new RCP_Zardis();

if (!function_exists('change_cancelled_to_pending')) {	

	add_action('rcp_set_status', 'change_cancelled_to_pending', 10, 2);

	function change_cancelled_to_pending($status, $user_id)
	{
		if ($status == 'cancelled') {

			rcp_set_status($user_id, 'expired');

			return TRUE;
		}
	}
}

if (!function_exists('RCP_User_Registration_Data') && !function_exists('RCP_User_Registration_Data')) {

	add_filter('rcp_user_registration_data', 'RCP_User_Registration_Data');

	function RCP_User_Registration_Data($user)
	{
		$old_subscription_id = get_user_meta($user['id'], 'rcp_subscription_level', TRUE);

		if (!empty($old_subscription_id)) {

			update_user_meta($user['id'], 'rcp_subscription_level_old', $old_subscription_id);
		}

		$user_info = get_userdata($user['id']);
		
		$old_user_role = implode(', ', $user_info->roles);

		if (!empty($old_user_role)) {

			update_user_meta($user['id'], 'rcp_user_role_old', $old_user_role);
		}

		return $user;
	}
}
