<?php
require_once(DIR_SYSTEM . 'library/zardis_func/sender.php');

class ControllerPaymentZardis extends Controller
{
    protected function index()
    {
        $this->language->load('payment/zardis');
        $this->data['button_confirm'] = $this->language->get('button_confirm');

        $this->data['text_wait'] = $this->language->get('text_wait');
        $this->data['text_ersal'] = $this->language->get('text_ersal');
        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/zardis.tpl')) {
            $this->template = $this->config->get('config_template') . '/template/paymentZardis.tpl';
        } else {
            $this->template = 'default/template/payment/zardis.tpl';
        }

        $this->render();
    }

    public function confirm()
    {

        $this->load->model('checkout/order');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $this->load->library('encryption');

        $encryption = new Encryption($this->config->get('config_encryption'));

        //$this->data['Amount'] = $this->currency->format($order_info['total'], 'TMN', $order_info['value'], FALSE);


        $this->data['Amount'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);

        //$this->data['Amount']=$this->data['Amount']\10;


        $this->data['PIN'] = $this->config->get('Zardis_PIN');


        $this->data['ResNum'] = $this->session->data['order_id'];

        $this->data['return'] = $this->url->link('checkout/success', '', 'SSL');
        //$this->data['return'] = HTTPS_SERVER . 'index.php?route=checkout/success';

        $this->data['cancel_return'] = $this->url->link('checkout/payment', '', 'SSL');
        //$this->data['cancel_return'] = HTTPS_SERVER . 'index.php?route=checkout/payment';

        $this->data['back'] = $this->url->link('checkout/payment', '', 'SSL');

        $amount = $this->data['Amount'];
        if ($this->currency->getCode() != 'RLS') {
            $amount = $amount * 10;
        }

        $this->data['order_id'] = $encryption->encrypt($this->session->data['order_id']);

        $callbackUrl = urlencode($this->url->link('payment/zardis/callback', 'order_id=' . $this->data['order_id'], 'SSL'));

        $result = send($this->data['URL'], $this->data['PIN'], $amount, $callbackUrl);
        $result = json_decode($result);
        if ($result->status == 0) {

        }

        if ($result->status) {
            $this->data['action'] = "https://pay.zardis.net/invoice/pay/$result->invoice_key";
            $json = [];
            $json['success'] = $this->data['action'];
            $this->response->setOutput(json_encode($json));
        } else {
            $json = [];
            $json['error'] = $result->errorMessage . ".<br>";
            $this->response->setOutput(json_encode($json));
        }
    }


    public function callback()
    {
        $this->load->library('encryption');

        $encryption = new Encryption($this->config->get('config_encryption'));
        $inv_key = $_POST['invoice_key'];
        $order_id = $encryption->decrypt($this->request->get['order_id']);
        $debugmod = false;
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);
        $Amount = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);        //echo $this->data['Amount'];
        $amount = $Amount / $order_info['currency_value'];

        if ($order_info) {
            $this->data['PIN'] = $this->config->get('Zardis_PIN');
            $result = verify($this->data['PIN'], $inv_key);
            $result = json_decode($result);
            
            if (($result->status == 1) or ($debugmod == true)) {
                $this->model_checkout_order->confirm($order_id, $this->config->get('Zardis_order_status_id'), 'شماره رسيد ديجيتالي; Authority: ' . $result->bank_code);
                $this->response->setOutput('<html><head><meta http-equiv="refresh" CONTENT="2; url=' . $this->url->link('checkout/success') . '"></head><body><table border="0" width="100%"><tr><td>&nbsp;</td><td style="border: 1px solid gray; font-family: tahoma; font-size: 14px; direction: rtl; text-align: right;">با تشکر پرداخت تکمیل شد.لطفا چند لحظه صبر کنید و یا  <a href="' . $this->url->link('checkout/success') . '"><b>اینجا کلیک نمایید</b></a></td><td>&nbsp;</td></tr></table></body></html>');
            } else {
                $this->response->setOutput('<html><body><table border="0" width="100%"><tr><td>&nbsp;</td><td style="border: 1px solid gray; font-family: tahoma; font-size: 14px; direction: rtl; text-align: right;">.<br />خريد انجام نشد<br /><a href="' . $this->url->link('checkout/cart') . '"><b>بازگشت به فروشگاه</b></a></td><td>&nbsp;</td></tr></table></body></html>');
            }
        } else {
            $this->response->setOutput('<html><body><table border="0" width="100%"><tr><td>&nbsp;</td><td style="border: 1px solid gray; font-family: tahoma; font-size: 14px; direction: rtl; text-align: right;">.<br /><br /><a href="' . $this->url->link('checkout/cart') . '"><b>بازگشت به فروشگاه</b></a></td><td>&nbsp;</td></tr></table></body></html>');
        }
    }
}