<?php
class gateway_Zardis extends gatewayCore
{
	public function __construct( ipsRegistry $registry ) 
	{
		parent::__construct($registry);
		require_once(IPSLib::getAppDir('nexus') . '/sources/zardisconfig.php');
		$this->Zardis_wsconfig = $ws_config;
	}
    
  	 public $maxAmounts = array(
        'USD'    => '*',
		'IRR'    => '*'
	);
    
    private function Zardis_pay($api_key, $amount, $redirect){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/request');
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key&amount=$amount&return_url=$redirect");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }

    private function Zardis_verify($api_key, $inv_key){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/check/'.$inv_key);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
	
	public function payScreen() 
	{
		$res = false;
		$pin = $this->method['m_settings']['pin'];
		if(empty($pin)) 
			return false;	
		
		$amount = $this->transaction['t_amount'];
        
        $redirect = ($this->settings['base_url_https']?$this->settings['base_url_https']:$this->settings['base_url']) . "app=nexus&module=payments&section=receive&validate=Zardis&nexusinvoice={$this->invoice->__get('id')}&transid={$this->transaction['t_id']}";
        $result = $this->Zardis_pay($pin,$amount,$redirect);
        $result = json_decode($result,1);

        if($result['status'] == 1) {
            return array("formUrl"    => 'https://pay.zardis.net/invoice/pay/'.$result['invoice_key']);
        } else {
            return false;
        }
	}

	public function validatePayment()
	{	
		$pin = $this->method['m_settings']['pin'];
		if(empty($pin)) 
			return false;

		$amount = $this->transaction['t_amount'];
		$inv_key = !empty($_POST['invoice_key']) ? $_POST['invoice_key'] : 0;
		
        $result = $this->Zardis_verify($pin, $inv_key);
		$result = json_decode($result,1);
        if($result['status'] == 1) {
            return array( 'status' => "okay", 'amount' => $amount, 'gw_id' => $result['bank_code']);
        } else {
            return false;
        }
	}
}
