<?php
function Edd_Zardis_pay($api_key, $amount, $redirect){
	$ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/request');
    curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key&amount=$amount&return_url=$redirect");
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}
function Edd_Zardis_verify($api_key, $inv_key) {
	$ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,'https://pay.zardis.net/invoice/check/'.$inv_key);
    curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key");
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}


if (!function_exists('edd_rial')) {

    function edd_rial($formatted, $currency, $price) {
        return $price . ' ریال';
    }

}
add_filter('edd_rial_currency_filter_after', 'edd_rial', 10, 3);

add_action('init', 'Zardis_start_session', 1);
function Zardis_start_session() {
    if(!session_id()) {
        @session_start();
    }
}

function add_Zardis_gateway($gateways) {
    $gateways['Zardis'] = array(
        'admin_label' => 'Zardis',
        'checkout_label' => 'Zardis'
    );
    return $gateways;
}

add_filter('edd_payment_gateways', 'add_Zardis_gateway');

function Zardis_cc_form() {
    return;
}

add_action('edd_Zardis_cc_form', 'Zardis_cc_form');

function Zardis_process($purchase_data) {
    
    for ($crashes = 0; $crashes < 10; $crashes++) {

    global $edd_options;

    $payment_data = array(
        'price' => $purchase_data['price'],
        'date' => $purchase_data['date'],
        'user_email' => $purchase_data['post_data']['edd_email'],
        'purchase_key' => $purchase_data['purchase_key'],
        'currency' => $edd_options['currency'],
        'downloads' => $purchase_data['downloads'],
        'cart_details' => $purchase_data['cart_details'],
        'user_info' => $purchase_data['user_info'],
        'status' => 'pending'
    );
    $payment = edd_insert_payment($payment_data);

    if ($payment) {
        $_SESSION['edd_Zardis_record'] = $payment;
        $return = add_query_arg('verify', 'Zardis', get_permalink($edd_options['success_page']));
		$price = $payment_data['price'];
        $api = $edd_options['api'];
		
		$result = Edd_Zardis_pay($api,$price,$return);
		
		if($result['status'] == 1) {
			$is_ready = true;
			break;
		}
		
	}
	else {
        edd_send_back_to_checkout('?payment-mode=' . $purchase_data['post_data']['edd-gateway']);
    }
 }
    if (isset($is_ready)){
        $go = "https://pay.zardis.net/invoice/pay/".$result['invoice_key'];
        wp_redirect($go);
    }else{
        edd_update_payment_status($payment, 'failed');
        wp_die('خطایی هنگام اتصال به درگاه رخ داد');
    }
}

add_action('edd_gateway_Zardis', 'Zardis_process');

function Zardis_verify() {
	
    global $edd_options;
    if (isset($_GET['verify']) && $_GET['verify'] == 'Zardis') {
        $payment = $_SESSION['edd_Zardis_record'];
	    $api = $edd_options['api'];
	    $inv_id = $_POST['invoice_key'];
	    $result = Edd_Zardis_verify($api,$inv_id);
	    $result = json_decode($result);

	    if($result->status == 1)
	    {
		    edd_update_payment_status($payment, 'publish');
		    edd_insert_payment_note($payment, 'نتیجه بازگشت: وضعیت: موفق و کد پرداخت: '.$result->bank_code);
		    edd_send_to_success_page();
	    }
	    else
	    {
		    edd_empty_cart();
		    edd_update_payment_status($payment, 'failed');
            wp_redirect(get_permalink($edd_options['failure_page']));
	    }
    }
	
}
add_action('init', 'Zardis_verify');

function Zardis_settings($settings) {
    $Zardis_options = array(
        array(
            'id' => 'api',
            'type' => 'text',
            'name' => 'API Zardis',
            'desc' => ''
        )
    );
    return array_merge($settings, $Zardis_options);
}

add_filter('edd_settings_gateways', 'Zardis_settings');
